/* @#[TAB_NAME="Cable Handling"] */
/* @#[FULL_WINDOW='1']          */
import QtCharts
import QtCore
import QtQuick
import QtQuick.Layouts
import QtQuick.Controls
import "../UiLibrary"
import "../UiLibrary/formatUtil.mjs" as FU
import "Base"

PluginPanel {
	id: main_panel
	
	component ResetDistButton: Button { // Buttons for resetting section or total deviation
		palette.button: buttonColor; palette.buttonText: 'white'
		background.implicitHeight: 22
		property string statusTip: 'Click to reset distance to zero'
	}	
	component LeftPanel: Item { // Tension Gauges on LHS
		RowLayout {
			anchors.fill: parent; anchors.rightMargin: 30
			ColumnLayout {
				Layout.fillHeight: true
				Item {
					Layout.fillWidth: true;	height: childrenRect.height
					ItemLabel {
						text: `<b>Tension (${engineName(0)})</b><br>[${forceMetric.unitName}]`; font.bold: false; onContextMenu: forceUnitSelectHandler(); statusTip: "Click right to change force units"
						anchors.horizontalCenter: parent.horizontalCenter
					}
				}
				Item {
					Layout.fillWidth: true;	Layout.fillHeight: true; Layout.bottomMargin: 25
					NeedleGauge {
						id: tension1_gauge
						onContextMenu: forceUnitSelectHandler();
						valueBarWidth: gaugeBarWidth
						orientation: Qt.Vertical
						minimumValue: 0
						value: forceMetric.convert(fU.num(Cable.Primary.Smoothed.Tension, 0), DisplayMetric.FORCE.IN_kN, forceMetric.modeIndex)
						markerDecimals: 1
						markerValue: forceMetric.convert(fU.num(Cable.Primary.Tension, 0), DisplayMetric.FORCE.IN_kN, forceMetric.modeIndex)
						maximumValue: fU.calcTickScale(0, tensionRangeMax(plugin.tensionScale, forceMetric.modeIndex)).maxValue
						//tickmarkStepSize: fU.calcTickScale(minimumValue, maximumValue).tickStep
						height: parent.height; implicitHeight: parent.height; anchors.horizontalCenter: parent.horizontalCenter
						readonly property real desiredTension: forceMetric.convert(plugin.desiredTensionValue, DisplayMetric.FORCE.IN_kN, forceMetric.modeIndex)
						readonly property real ttPercent: 1.0 - (desiredTension / maximumValue)
						readonly property bool ttValid: (ttPercent >= 0.1 && ttPercent < 0.95)
						gradient: Gradient {
							GradientStop { position: 0.0; color: gaugeRed }
							GradientStop { position: 0.05; color: gaugeRed }
							GradientStop { position: 0.1; color: gaugeYellow }
							GradientStop { position: tension1_gauge.ttValid ? tension1_gauge.ttPercent + 0.05 : 0.45; color: gaugeYellow }
							GradientStop { position: tension1_gauge.ttValid ? tension1_gauge.ttPercent : 0.5; color: tension1_gauge.ttValid ? gaugeGreen : gaugeYellow }
							GradientStop { position: tension1_gauge.ttValid ? tension1_gauge.ttPercent - 0.05 : 0.55; color: gaugeYellow }
							GradientStop { position: 1.0; color: gaugeYellow }
						}
					}
				}
			}
			ColumnLayout {
				Layout.fillHeight: true
				Item {
					Layout.fillWidth: true;	height: childrenRect.height
					ItemLabel {
						text: `<b>Tension (${engineName(1)})</b><br>[${forceMetric.unitName}]`; font.bold: false; onContextMenu: forceUnitSelectHandler(); statusTip: "Click right to change force units"
						anchors.horizontalCenter: parent.horizontalCenter
					}
				}
				Item {
					Layout.fillWidth: true;	Layout.fillHeight: true; Layout.bottomMargin: 25
					NeedleGauge {
						id: tension2_gauge
						onContextMenu: forceUnitSelectHandler();
						valueBarWidth: gaugeBarWidth
						orientation: Qt.Vertical
						minimumValue: 0
						value: forceMetric.convert(fU.num(Cable.AUX1.Smoothed.Tension, 0), DisplayMetric.FORCE.IN_kN, forceMetric.modeIndex)
						markerDecimals: 1
						markerValue: forceMetric.convert(fU.num(Cable.AUX1.Tension, 0), DisplayMetric.FORCE.IN_kN, forceMetric.modeIndex)
						maximumValue: fU.calcTickScale(0, tensionRangeMax(plugin.tensionScale, forceMetric.modeIndex)).maxValue
						//tickmarkStepSize: fU.calcTickScale(minimumValue, maximumValue).tickStep
						height: parent.height; implicitHeight: parent.height; anchors.horizontalCenter: parent.horizontalCenter
						readonly property real desiredTension: forceMetric.convert(plugin.desiredTensionValue, DisplayMetric.FORCE.IN_kN, forceMetric.modeIndex)
						readonly property real ttPercent: 1.0 - (desiredTension / maximumValue)
						readonly property bool ttValid: (ttPercent >= 0.1 && ttPercent < 0.95)
						gradient: Gradient {
							GradientStop { position: 0.0; color: gaugeRed }
							GradientStop { position: 0.05; color: gaugeRed }
							GradientStop { position: 0.1; color: gaugeYellow }
							GradientStop { position: tension2_gauge.ttValid ? tension2_gauge.ttPercent + 0.05 : 0.45; color: gaugeYellow }
							GradientStop { position: tension2_gauge.ttValid ? tension2_gauge.ttPercent : 0.5; color: tension2_gauge.ttValid ? gaugeGreen : gaugeYellow }
							GradientStop { position: tension2_gauge.ttValid ? tension2_gauge.ttPercent - 0.05 : 0.55; color: gaugeYellow }
							GradientStop { position: 1.0; color: gaugeYellow }
						}
					}
				}
			}	
		}	
	} // END LeftPanel		
	component ChartPanel: Item { // Chart Area and series selection checkboxes
		property var checkModel: [{ series: [smo_tension1, smo_tension2] }, { series: [raw_tension1, raw_tension2] }]
		property int totalPoints: 100		
		property int norecurse: 1			
		ColumnLayout {
			spacing: 0		
			anchors.fill: parent
			Item {
				Layout.fillWidth: true;	Layout.fillHeight: true; Layout.margins: -10
				ChartView {
					id: chartview1
					width: parent.width; height: parent.height
					legend.alignment: Qt.AlignBottom; antialiasing: true
					backgroundColor: PanelStyle.backgroundColor; titleColor: PanelStyle.labelColor
					legend.labelColor: PanelStyle.labelColor; legend.visible: false
					ValueAxis { // time
						id: axisTX
						min: 0;	max: totalPoints - 1; reverse: true						
						labelsColor: PanelStyle.inDarkMode ? "white" : "black"; gridLineColor: PanelStyle.inDarkMode ? "white" : "black"
						color: PanelStyle.inDarkMode ? "white" : "black"
					}
					ValueAxis { // tension
						id: axisTY
						min: 0;	max: tensionRangeMax(plugin.tensionScale, forceMetric.modeIndex)
						labelsColor: PanelStyle.inDarkMode ? "#008080" : '#008080';	gridLineColor: PanelStyle.inDarkMode ? "white" : "black"
						color: PanelStyle.inDarkMode ? "white" : "black"
					}
					LineSeries {
						id: raw_tension1; name: "Tension (raw)"; property int sindex: 0 + 1;	color: '#008000'; width: 2
						axisX: axisTX; axisY: axisTY
					}
					LineSeries {
						id: smo_tension1; name: "Tension (smoothed)"; property int sindex: 0 + 0; color: '#008080'; width: 4
						axisX: axisTX; axisY: axisTY
					}
					Rectangle {
						id: zb;
						x: chartview1.plotArea.right - 66; y: chartview1.plotArea.top + 10;						
						RowLayout {
							ZoomButton { labelText: '+'; statusTip: 'Click to zoom in';	 onClicked: zoom(10);  enabled: totalPoints < 100	}
							ZoomButton { labelText: '-'; statusTip: 'Click to zoom out'; onClicked: zoom(-10); enabled: totalPoints > 10	}
						}
					}
					Item {
						x: chartview1.plotArea.right - (childrenRect.width + 30 + zb.childrenRect.width); y: chartview1.plotArea.top + 10; z: 1												
						ColumnLayout {
							ItemLabel       { text: 'From section start [km]'; opacity: 0.5 }
							ValueText       { text: fU.formatValue(Cable.DistFromSectStart, 1, 3); font.pixelSize: 38; opacity: 0.5 }
							ResetDistButton { text: '<b>Reset</b>'; onClicked: Cable.DistFromSectStart = 0; opacity: hovered ? 1.0 : 0.4}
						}						
					}
				}
			}
			Item {
				Layout.fillWidth: true;	Layout.fillHeight: true; Layout.margins: -10
				ChartView {
					id: chartview2
					width: parent.width; height: parent.height
					legend.alignment: Qt.AlignBottom; antialiasing: true
					backgroundColor: PanelStyle.backgroundColor; titleColor: PanelStyle.labelColor
					legend.labelColor: PanelStyle.labelColor; legend.visible: false
					ValueAxis { // time
						id: axisBX
						min: 0;	max: totalPoints - 1; reverse: true						
						labelsColor: PanelStyle.inDarkMode ? "white" : "black"; gridLineColor: PanelStyle.inDarkMode ? "white" : "black"
						color: PanelStyle.inDarkMode ? "white" : "black"
					}
					ValueAxis { // tension
						id: axisBY
						min: 0;	max: tensionRangeMax(plugin.tensionScale, forceMetric.modeIndex)
						labelsColor: PanelStyle.inDarkMode ? "#008080" : '#008080';	gridLineColor: PanelStyle.inDarkMode ? "white" : "black"
						color: PanelStyle.inDarkMode ? "white" : "black"
					}
					LineSeries {
						id: raw_tension2; name: "Tension (raw)"; property int sindex: 2 + 1;	color: '#008000'; width: 2
						axisX: axisBX; axisY: axisBY
					}
					LineSeries {
						id: smo_tension2; name: "Tension (smoothed)"; property int sindex: 2 + 0; color: '#008080'; width: 4
						axisX: axisBX; axisY: axisBY
					}
					Rectangle {
						x: chartview2.plotArea.right - 66; y: chartview2.plotArea.top + 10
						RowLayout {
							ZoomButton { labelText: '+'; statusTip: 'Click to zoom in';	 onClicked: zoom(10);  enabled: totalPoints < 100	}
							ZoomButton { labelText: '-'; statusTip: 'Click to zoom out'; onClicked: zoom(-10); enabled: totalPoints > 10	}
						}
					}
					Rectangle {
						id: bods
						x: chartview2.plotArea.right - (childrenRect.width + 30 + zb.childrenRect.width); y: chartview2.plotArea.top + 10						
						opacity: 0.5
						property real toNextClamped: fU.num(Cable.DistToNextBody, 99999)
						visible: toNextClamped > -500 && toNextClamped < 99999
						OpacityAnimator on opacity {
							from: 0.4; to: 0.85;
							loops: Animation.Infinite; duration: 1500							
							running: bods.toNextClamped > 0 && bods.toNextClamped <= 200
						}
						ColumnLayout {
							ItemLabel { text: 'Cable to go until body [km]' }
							ValueText { text: fU.formatScaledValue(Cable.DistToNextBody, 0.001, 1, 3) }
							ValueText { text: fU.asString(Cable.NextBodyName) }
							ValueText { text: bods.toNextClamped }
						}
					}
				}
			}					
			Item {				
				Layout.fillWidth: true; Layout.preferredHeight: 60
				Layout.topMargin: -19; Layout.bottomMargin: 9
				RowLayout {
					height: 60
					Item { width: 49 }
					Repeater {
						id: checkBoxes
						model: checkModel
						Item {
							Layout.preferredWidth: 150
							Layout.preferredHeight: childrenRect.height
							ColorCheckBox {
								anchors.horizontalCenter: parent.horizontalCenter
								text: modelData.series[0].name
								selColor: modelData.series[0].color; checked: modelData.series[0].visible
								onCheckedChanged: {
									if (norecurse == 0) { 
										modelData.series[0].visible = checked;
										modelData.series[1].visible = checked;
										updateSeriesVisibility();
									}
								}
							}
						}
					}			
				}
				RowLayout {
					height: 60
					x: parent.width - (childrenRect.width + 28)
					ItemLabel { text: `<b>Target Tension</b> [${forceMetric.unitName}]`; font.bold: false; onContextMenu: forceUnitSelectHandler(); statusTip: "Click right to change force units" }
					ValueText { text: forceMetric.convert(plugin.desiredTensionValue, DisplayMetric.FORCE.IN_kN, forceMetric.modeIndex).toFixed(1); onContextMenu: forceUnitSelectHandler(); statusTip: "Click right to change force units" }
				}
			}
		}
		Timer { id: refreshTimer; interval: 500; repeat: true; onTriggered: refreshData() }
				
		function updateSeriesVisibility() {
			norecurse++;
			var vflags = 0;
			for (var i = 0; i < checkModel.length; i++) {
				var series = checkModel[i].series[0];
				if (series.visible) {
					vflags |= 1 << series.sindex; 
				}
			}
			if (vflags == 0) {
				// we JUST wont allow you to deselect all checkboxes!!
				vflags = 1 << checkModel[0].series[0].sindex;
				settings.visibleTensionSeries = vflags;
				restoreSeriesVisibility(vflags);
			}
			else {
				settings.visibleTensionSeries = vflags;
			}
			norecurse--;
		}	
		function restoreSeriesVisibility(vflags = 0) {
			norecurse++;
			if (vflags == 0) {
				vflags = parseInt(settings.visibleTensionSeries);
			}
			if (vflags > 0 && vflags < 1024) {
				for (var i = 0; i < checkModel.length; i++) {
					var series = checkModel[i].series;
					series[0].visible =  (vflags & (1 << series[0].sindex)) != 0;
					series[1].visible =  (vflags & (1 << series[0].sindex)) != 0;
				}
			}		
			norecurse--;
		}	
		function getRealData(key, multiplier) {
			var a = [];
			a.length = totalPoints;
			var y = plugin.cableSeriesData(key).data;
			for (var i = 0; i < totalPoints; i++) {
				a[i] = Qt.point(totalPoints - (i + 1),y[i] * multiplier);
			}
			return a;
		}	
		function zoom(amount) {
			var q = Math.min(Math.max(10, totalPoints + amount), 100);
			if (totalPoints != q) {
				totalPoints = q;
				refreshData();
			}
		}								
		function refreshData() {
			VUtil.updateChartSeries(smo_tension1, getRealData(smo_tension1.sindex, forceMetric.multiplierForConversion(DisplayMetric.FORCE.IN_Kilonewton)));
			VUtil.updateChartSeries(raw_tension1, getRealData(raw_tension1.sindex, forceMetric.multiplierForConversion(DisplayMetric.FORCE.IN_Kilonewton)));
			VUtil.updateChartSeries(smo_tension2, getRealData(smo_tension2.sindex, forceMetric.multiplierForConversion(DisplayMetric.FORCE.IN_Kilonewton)));
			VUtil.updateChartSeries(raw_tension2, getRealData(raw_tension2.sindex, forceMetric.multiplierForConversion(DisplayMetric.FORCE.IN_Kilonewton)));
		}	
		function applyBackgroundGradient() {
			// Due to QML chartview design we cant seem to directly get a pointer to the QChart object from the QML item but we can obtain it in C++ from any series belonging to the chartview
			// so we pass the first series and let the C++ code get a pointer to the QChart
			VUtil.setChartBackgroundGradient(chartview1.series(0), PanelStyle.inDarkMode ? [Qt.rgba(0.269, 0.269, 0.269, 1.0), PanelStyle.backgroundColor] : [PanelStyle.backgroundColor, Qt.darker(PanelStyle.backgroundColor, 1.2)]);
			VUtil.setChartBackgroundGradient(chartview2.series(0), PanelStyle.inDarkMode ? [Qt.rgba(0.269, 0.269, 0.269, 1.0), PanelStyle.backgroundColor] : [PanelStyle.backgroundColor, Qt.darker(PanelStyle.backgroundColor, 1.2)]);
		}					
		function start() {
			applyBackgroundGradient();
			refreshData();
			restoreSeriesVisibility();
			refreshTimer.start();
			norecurse = 0;
			_wktnav.themeChanged.connect(function(name) {
				applyBackgroundGradient();
			});			
		}		
	} // END ChartPanel
	
	RowLayout {	// MAIN LAYOUT
		anchors.fill: parent
		Item {
			Layout.preferredWidth: 360;	Layout.fillHeight: true; Layout.leftMargin: 5		
			ColumnLayout {
				id: lefpan
				readonly property int fontPx1: 30;	readonly property int fontPx2: 22
				anchors.fill: parent; anchors.topMargin: 24; spacing: 16
				Item {
					Layout.fillWidth: true; Layout.preferredHeight: childrenRect.height
					PanelBox {
						width: parent.width
						text: `${engineName(0)}`
						GridLayout {
							width: parent.width; columns: 2; y: 7
							ItemLabel { text: `<b>Cable</b> [km]`;	                                  font.bold: false                                                                                            }
							ItemLabel { text: `<b>Cable Speed</b> [${speedMetric.unitName}]`;	      font.bold: false; onContextMenu: speedUnitSelectHandler(); statusTip: "Click right to change speed units"   }
							ValueText { text: fU.formatValue(Cable.Primary.Length, 1, 3);                                                                                          font.pixelSize: lefpan.fontPx1 }							
							ValueText { text: fU.formatValue(speedMetric.convert(fU.num(Cable.Primary.Smoothed.Speed), DisplayMetric.SPEED.IN_Km_h, speedMetric.modeIndex), 1, 2); font.pixelSize: lefpan.fontPx1; onContextMenu: speedUnitSelectHandler(); statusTip: "Click right to change speed units" }							
							ItemLabel { text: `<b>Tension Smooth</b> [${forceMetric.unitName}]`;	  font.bold: false; onContextMenu: forceUnitSelectHandler(); statusTip: "Click right to change force units"   }
							ItemLabel { text: `<b>Tension Raw</b> [${forceMetric.unitName}]`;	      font.bold: false; onContextMenu: forceUnitSelectHandler(); statusTip: "Click right to change force units"   }														
							ValueText { text: fU.formatValue(forceMetric.convert(fU.num(Cable.Primary.Smoothed.Tension), DisplayMetric.FORCE.IN_kN, forceMetric.modeIndex), 1, 1); font.pixelSize: lefpan.fontPx2; onContextMenu: forceUnitSelectHandler(); statusTip: "Click right to change force units" }
							ValueText { text: fU.formatValue(forceMetric.convert(fU.num(Cable.Primary.Tension), DisplayMetric.FORCE.IN_kN, forceMetric.modeIndex), 1, 1);          font.pixelSize: lefpan.fontPx2; onContextMenu: forceUnitSelectHandler(); statusTip: "Click right to change force units" }
							Item { height: 2 }
						}
					}
				}
				Item {
					Layout.fillWidth: true; Layout.preferredHeight: childrenRect.height
					PanelBox {
						width: parent.width
						text: `${engineName(1)}`
						GridLayout {
							width: parent.width; columns: 2; y: 7
							ItemLabel { text: `<b>Cable</b> [km]`;	                                  font.bold: false                                                                                            }
							ItemLabel { text: `<b>Cable Speed</b> [${speedMetric.unitName}]`;	      font.bold: false; onContextMenu: speedUnitSelectHandler(); statusTip: "Click right to change speed units"   }
							ValueText { text: fU.formatValue(Cable.AUX1.Length, 1, 3);                                                                                          font.pixelSize: lefpan.fontPx1    }							
							ValueText { text: fU.formatValue(speedMetric.convert(fU.num(Cable.AUX1.Smoothed.Speed), DisplayMetric.SPEED.IN_Km_h, speedMetric.modeIndex), 1, 2); font.pixelSize: lefpan.fontPx1; onContextMenu: speedUnitSelectHandler(); statusTip: "Click right to change speed units"   }							
							ItemLabel { text: `<b>Tension Smooth</b> [${forceMetric.unitName}]`;	  font.bold: false; onContextMenu: forceUnitSelectHandler(); statusTip: "Click right to change force units"   }
							ItemLabel { text: `<b>Tension Raw</b> [${forceMetric.unitName}]`;	      font.bold: false; onContextMenu: forceUnitSelectHandler(); statusTip: "Click right to change force units"   }
							ValueText { text: fU.formatValue(forceMetric.convert(fU.num(Cable.AUX1.Smoothed.Tension), DisplayMetric.FORCE.IN_kN, forceMetric.modeIndex), 1, 1); font.pixelSize: lefpan.fontPx2; onContextMenu: forceUnitSelectHandler(); statusTip: "Click right to change force units"   }
							ValueText { text: fU.formatValue(forceMetric.convert(fU.num(Cable.AUX1.Tension), DisplayMetric.FORCE.IN_kN, forceMetric.modeIndex), 1, 1);          font.pixelSize: lefpan.fontPx2; onContextMenu: forceUnitSelectHandler(); statusTip: "Click right to change force units"   }
							Item { height: 2 }
						}
					}
				}
				Item {
					Layout.fillWidth: true; Layout.fillHeight: true					
					LeftPanel { anchors.fill: parent }
				}
			}
		}
		Item {
			Layout.fillWidth: true;	Layout.fillHeight: true
			ChartPanel {
				id: chart_panel; anchors.fill: parent
			}
		}
	}
	function engineName(ix) {
		// convert & ampersands in (default) engine names to HTML underscored letters
		return plugin.engineNames[plugin.enginePhysicalIndex[ix]].replace(/&([a-zA-Z0-9])/, "<u>$1</u>");
	}
	Component.onCompleted: {
		if (startPlugin()) {
			chart_panel.start();
		}
	}		
}