import QtCore
import QtQuick
import QtQuick.Layouts
import QtQuick.Controls
import "../../UiLibrary"
import "../../UiLibrary/formatUtil.mjs" as FU

Rectangle {
	id: main_panel
	property var fU: null
	color: PanelStyle.backgroundColor
	property var plugin: _wktnav.LoadPlugin('BSPCableDialogs');
	property var pluginInstance: null
	signal customiseContextMenu(QtObject w, point pos, QtObject menu)
	property var speedMetric: DisplayMetric.optionFor(DisplayMetric.UNIT_SPEED);
	property var forceMetric: DisplayMetric.optionFor(DisplayMetric.UNIT_FORCE);
	property Settings settings: Settings {
		category: 'UIPlugins/cable_ops_plugin.qml'
		property string visibleSeries
		property string visibleTensionSeries		
		property bool engTextDisplay: true
		property bool swapSdGauge: false
	}
	readonly property real gaugeBarWidth: 22
	readonly property real gAlpha: PanelStyle.inDarkMode ? 0.74 : 0.95
	readonly property color gaugeYellow: Qt.darker(Qt.rgba(1.0, 0.988, 0.219, gAlpha), PanelStyle.inDarkMode ? 1.0 : 1.1)
	readonly property color gaugeGreen: Qt.darker(Qt.rgba(0.0, 1.0, 0.0, gAlpha), PanelStyle.inDarkMode ? 1.0 : 1.1)
	readonly property color gaugeRed: Qt.darker(Qt.rgba(1.0, 0.0, 0.0, gAlpha), PanelStyle.inDarkMode ? 1.0 : 1.1)
	readonly property color buttonColor: Qt.darker(PanelStyle.labelColor, 2.0)
	
	Item {
		x: main_panel.width - width; y: 0; z: 1; width: 320
		RowLayout {
			StdHyperlink {	href: 'bsp://cableoptionsdialog';  label: 'Options';    statusTip: 'Click to open options dialog'           }
			StdHyperlink {	href: 'bsp://manualroutedialog';   label: 'Route';      statusTip: 'Click to open cable route dialog'        }
			StdHyperlink {	href: 'bsp://autoroutedialog';     label: 'Auto Route'; statusTip: 'Click to open auto route dialog'         }
			StdHyperlink {	href: 'bsp://targetslackdialog';   label: 'T. Slack';   statusTip: 'Click to open target slack dialog'       }
			StdHyperlink {	href: 'bsp://prevdistdialog';      label: 'Dist';  	    statusTip: 'Click to open prev distances dialog'     }
			StdHyperlink {	href: 'bsp://encoderparamsdialog'; label: 'Enc';        statusTip: 'Click to open encoder parameters dialog' }
		}
	}
	MenuBarInsertion {
		path: 'Setup'
		Action { text: 'Encoders/Strain Gauges...'; onTriggered: openLink('bsp://encoderparamsdialog'); icon.source: 'qrc:/qrc/Resources/loadcell.png'; property string statusTip: 'Click to open encoder parameters dialog' }
		Action { text: 'Target Slack...';           onTriggered: openLink('bsp://targetslackdialog');   icon.source: 'qrc:/qrc/Resources/slack.png'; property string statusTip: 'Click to open target slack dialog'     }
		Action { text: 'Use Next Mean Slack';       onTriggered: plugin.useNextMeanSlack = checked; checkable: true; checked: plugin.useNextMeanSlack  }
		SeparatorBar { }
	}
	MenuBarInsertion {
		path: 'View'
		Action { text: 'Cable Display Options...';  onTriggered: openLink('bsp://cableoptionsdialog');   icon.source: 'qrc:/qrc/Resources/cableui.png'; property string statusTip: 'Click to open options dialog' }
		SeparatorBar { }
	}
	MenuBarInsertion {
		path: 'Route'
		Menu {
			title: 'Cable Route'
			Action { text: 'Manual...';             onTriggered: openLink('bsp://manualroutedialog'); property string statusTip: 'Click to open cable route dialog' }                                                  
			Action { text: 'Automatic...';          onTriggered: openLink('bsp://autoroutedialog');   property string statusTip: 'Click to open auto route dialog'  }
			MenuSeparator { }
			Action { text: 'Distance Deviation...'; onTriggered: openLink('bsp://ddmethdialog');   icon.source: 'qrc:/qrc/Resources/distdev.png'; property string statusTip: 'Click to change distance deviation method' }
			Action { text: 'Previous Distances...'; onTriggered: openLink('bsp://prevdistdialog'); icon.source: '../images/ruler.png'; property string statusTip: 'Click to open prev distances dialog' }
		}
		SeparatorBar { }
	}
	function tensionRangeMax(scaleIndex, metricIndex) {
		const mapping = [25, 50, 100, 300, 400,	500];
		return forceMetric.convert((scaleIndex < mapping.length) ? mapping[scaleIndex] : 500, DisplayMetric.FORCE.IN_Kilonewton, metricIndex);
	}
	function speedRange(scaleIndex, metricIndex) {
		var mapping = [];
		mapping[DisplayMetric.SPEED.IN_Km_h] = [[-5, 10, 2.5], [0, 10, 0], [0, 20, 0],[0, 2, 0]];
		mapping[DisplayMetric.SPEED.IN_Knots] = [[-3, 6, 0], [0, 6, 0], [0, 12, 0],	[0, 2, 0]];
		mapping[DisplayMetric.SPEED.IN_M_per_Sec] = [[-1.5, 3, 0],	[0, 3, 0],	[0, 6, 0],[0, 0.6, 0]];
		mapping[DisplayMetric.SPEED.IN_M_per_Min] = [[-90, 180, 27],[0, 180, 20],[0, 360, 60],[0, 36, 6]];
		return (scaleIndex < 4) ? mapping[metricIndex][scaleIndex] : [0, 10, 0];
	}
	function distanceDeviationScale(scaleIndex) {
		const mapping = [10, 50, 100, 500 ];
		return (scaleIndex < mapping.length) ? mapping[scaleIndex] : 500;
	}
	function slackDeviationScale(scaleIndex) {
		const mapping = [5, 10, 100, 200 ];
		return (scaleIndex < mapping.length) ? mapping[scaleIndex] : 200;
	}	
	onCustomiseContextMenu: function(w, pos, menu) {
		PanelStyle.addThemeSelectionActions(w, menu);
	}
	function speedUnitSelectHandler() {
		_wktnav.execUnitSelectionPopupMenu(DisplayMetric.UNIT_SPEED);
	}	
	function forceUnitSelectHandler() {
		_wktnav.execUnitSelectionPopupMenu(DisplayMetric.UNIT_FORCE);
	}	
	function openLink(link) { plugin.showDialog(link.substr(6)); }	
	function startPlugin() {
		if (plugin !== null) {
			pluginInstance = plugin.createInstance();
			if (pluginInstance !== null) {
				fU = FU;
				return true;
			}
		}
		return false;
	}
}
